<?php
 
class Free_Issue_Process_Model extends CI_Model {
  
  
  function __construct() 
  {
    parent::__construct();
    $this->db->query("SET sql_mode=(SELECT REPLACE(@@sql_mode, 'ONLY_FULL_GROUP_BY', ''));");
  }
  
    
  	function save_free_product($data_item)
	{
		$result=$this->db->insert('free_issue_product',$data_item);
		return $result;
	}
	function get_free_issue_list($product_id)
    {
        $this->db->select('p.*,u.invoice_type_name');
        $this->db->from('free_issue_product p');
        $this->db->join('master_invoice_type u', 'u.invoice_type_id = p.price_type', 'inner');
        $this->db->where("p.free_status", 1);
        $this->db->where("p.product_id", $product_id);
        $this->db->where("p.is_deleted", 0);
        $query=$this->db->get();
        return $query->result_array();
    }
    function sale_free_product_list($sale_id)
    {
        
        $this->db->select('s.*');
        $this->db->select_sum('s.quantity');
        $this->db->from('sale_items s');
       // $this->db->join('product m', 's.product_id = m.product_id', 'inner');
        $this->db->where("s.sale_id", $sale_id);
        $this->db->where("s.free_enable", 1);
        //$this->db->where("m.group_free_issue_id", 0);
        $this->db->group_by("s.product_id");
        $query=$this->db->get();
        return $query->result_array();
    }
    function get_total_sale_product_qty($product_id,$sale_id,$batch_id){
        $this->db->select_sum('p.quantity');
        $this->db->from('sale_items p');
        $this->db->where('p.product_id', $product_id);
        $this->db->where('p.batch_id', $batch_id);
        $this->db->where('p.sale_id', $sale_id);
        $query = $this->db->get();
        $result=$query->row_array();
        if(isset($result['quantity']))
        {
            return $result['quantity'];
        }else{
       return 0;
        }
    }
     public function get_relevent_free_issue_block($product_id)
	{
	    $this->db->select('p.*');
        $this->db->from('free_issue_product p');
        $this->db->where("p.product_id ", $product_id);
        $this->db->where("p.free_status", 1);
        $this->db->where("p.is_deleted", 0);
        $this->db->limit(1);
        $query=$this->db->get();
        $result = $query->row_array();
        if(isset($result['fr_p_id'])){
            $return_result=array(
                'fr_p_id'=>$result['fr_p_id'],
                'free_qty'=>$result['free_qty'],
                'end_req_qty'=>$result['end_req_qty'],
            );
            return $return_result;
            
        }else{
            return false;
        }
	}
	function update_free_issue_product($data,$id)
	{
		if ($id>0)
		{
			$this->db->where('fr_p_id',$id);
		    return $this->db->update('free_issue_product',$data);
		}
		else 
		{
	        return false;
		}
	}
	
	public function get_free_issue_details($id){
     $this->db->select("si.*");
     $this->db->from("free_issue_product si");
     $this->db->where("si.fr_p_id",$id);
     $query = $this->db->get();  
     return $query->row_array();
  }
  
  
  
  public function invoice_free_isuue_generator($sale_id){
      
      $sale_free_product = $this->sale_free_product_list($sale_id);
    
    $total_free_issue=0;
       foreach ($sale_free_product as $row) {
             $free_issue_qty=1;
             $end_range=12;
             $valid_free_issue_qty=0;
           
             $issued_total=$row['quantity'];
             if($end_range!=0){
                $remain=$issued_total% $end_range;
                $entitle_qty=$issued_total-$remain;
                $valid_free_issue_qty=($entitle_qty/$end_range)*$free_issue_qty;
             }
             if($valid_free_issue_qty>0){
                 $data_free_product = array(
                                'sale_id' => $sale_id,
                                'product_id' => $row['product_id'],
                                'batch_id' => $row['batch_id'],
                                'quantity' => $valid_free_issue_qty,
                                'unit_price' => 0,
                                'item_cost' => $row['item_cost'],
                                'gross_total' => 0,
                                'discount' => 0,
                                'discount_val' => 0,
                                'total_item_cost' =>$row['item_cost'] * $valid_free_issue_qty,
                                'is_free_issue' => 1,
                                'direct_sale'=>0,
                                'delivery_id'=>$row['delivery_id'],
                            );
                 $total_free_issue  = +$row['item_cost'] * $valid_free_issue_qty;
                $this->sale_items_in($data_free_product);
             }
       }   
       
        $total_free_issue  = 0;
                   
                    if ($total_free_issue != 0) {
                        $pos_data = array(
                            'cost_total' => $total_cost_val + $total_free_issue
                        );
                       // $this->update_hw_sale($pos_data, $sale_id);
                    }
                   
                   
                   
                   
                   
                   
                   
                   
                   
                   
                   
                   
                   
                   
                   
                   
                   
                   
  }
   function sale_items_in($data)
  {
	  if($this->db->insert('sale_items', $data)){
        return true;
      }else{
        return false;
      }
  }
  	function update_hw_sale($data,$id)
	{
		if ($id>0)
		{
			$this->db->where('sale_id',$id);
		    return $this->db->update('sales',$data);
		}
		else 
		{
	        return false;
		}
	}
	public function get_sale_total_details($id){
     $this->db->select("si.*");
     $this->db->from("sales si");
     $this->db->where("si.sale_id",$id);
     $query = $this->db->get();  
     return $query->row_array();
  }
  
  
   public function order_free_isuue_generator($sale_id){
      $sale_free_product = $this->order_free_product_list($sale_id);
     
     
        foreach ($sale_free_product as $row) {
           //$return_result = $this->get_relevent_free_issue_block($row['product_id']);
             $free_issue_qty=1;
             $end_range=12;
             $valid_free_issue_qty=0;
            /* if(isset($return_result['free_qty'])){
                $free_issue_qty =$return_result['free_qty'];
                $end_range=$return_result['end_req_qty'];
             }*/
             $issued_total=$row['issue_qty'];
             if($end_range!=0){
                $remain=$issued_total% $end_range;
                $entitle_qty=$issued_total-$remain;
                $valid_free_issue_qty=($entitle_qty/$end_range)*$free_issue_qty;
             }
             
             $batch_list = $this->get_batch_list($row['product_id']);
             
            
             $last_read_batch_stock=0;
             $last_read_batch_id=0;
             $batch_cost=0;
             foreach($batch_list as $b){
                $bqty = $this->Stock_Counter_Model->get_stock_balance(1,$b['product_id'],$b['batch_id']);
               
                if($last_read_batch_stock<$bqty &&  $bqty>=$valid_free_issue_qty){
                    $last_read_batch_stock=$bqty;
                    $last_read_batch_id=$b['batch_id'];
                    $batch_cost=$b['product_cost'];
                }
             }
                    if($valid_free_issue_qty<=0){continue;}
                            $data_free_product = array(
                                'cus_order_master_id' => $sale_id,
                                'product_id' => $row['product_id'],
                                'batch_id' => $last_read_batch_id,
                                'issue_qty' => $valid_free_issue_qty,
                                'order_qty' => $valid_free_issue_qty,
                                'product_cost' => $batch_cost,
                                'product_price' => 0,
                                'total_cost' => $batch_cost * $valid_free_issue_qty,
                                'is_free_issue' => 1,
                                'free_issue_id' => 1,
                            );
                            $this->order_items_in($data_free_product);
                        }
  }
  
   function order_free_product_list($sale_id)
    {
        $this->db->select('s.*');
        $this->db->select_sum('s.issue_qty');
        $this->db->from('customer_order_items s');
        $this->db->join('product m', 's.product_id = m.product_id', 'inner');
        $this->db->where("s.cus_order_master_id", $sale_id);
        //$this->db->where("m.group_free_issue_id", 0);
        $this->db->group_by("s.product_id");
        $query=$this->db->get();
        return $query->result_array();
    }
   
   public function get_order_total_details($id){
     $this->db->select("si.*");
     $this->db->from("customer_order_master si");
     $this->db->where("si.cus_order_master_id",$id);
     $query = $this->db->get();  
     return $query->row_array();
  }
   function get_total_order_product_qty($product_id,$sale_id,$batch_id){
        $this->db->select_sum('p.issue_qty');
        $this->db->from('customer_order_items p');
        $this->db->where('p.product_id', $product_id);
        $this->db->where('p.batch_id', $batch_id);
        $this->db->where('p.cus_order_master_id', $sale_id);
        $query = $this->db->get();
        $result=$query->row_array();
        if(isset($result['issue_qty']))
        {
            return $result['issue_qty'];
        }else{
       return 0;
        }
    }
  
  function order_items_in($data)
  {
	  if($this->db->insert('customer_order_items', $data)){
        return true;
      }else{
        return false;
      }
  }
  
  function get_batch_list($product_id){
        $this->db->select('s.*');
        $this->db->from('batch_product s');
        $this->db->where("s.product_id", $product_id);
        $this->db->where("s.batch_status", 1);
        $query=$this->db->get();
        return $query->result_array();
  }
  
  public function order_group_free_issue_generator($sale_id){
      $sale_free_product = $this->order_free_product_list($sale_id);
     
        foreach ($sale_free_product as $row) {
           //$return_result = $this->get_relevent_free_issue_block($row['product_id']);
             $free_issue_qty=1;
             $end_range=12;
             $valid_free_issue_qty=0;
            /* if(isset($return_result['free_qty'])){
                $free_issue_qty =$return_result['free_qty'];
                $end_range=$return_result['end_req_qty'];
             }*/
             $issued_total=$row['issue_qty'];
             if($end_range!=0){
                $remain=$issued_total% $end_range;
                $entitle_qty=$issued_total-$remain;
                $valid_free_issue_qty=($entitle_qty/$end_range)*$free_issue_qty;
             }
             
             
             
             $batch_list = $this->get_batch_list($row['product_id']);
             
            
             $last_read_batch_stock=0;
             $last_read_batch_id=0;
             $batch_cost=0;
             foreach($batch_list as $b){
                $bqty = $this->Stock_Counter_Model->get_stock_balance('',$row['product_id'],$b['batch_id']);
                if($last_read_batch_stock<$bqty &&  $bqty>=$valid_free_issue_qty){
                    $last_read_batch_stock=$bqty;
                    $last_read_batch_id=$b['batch_id'];
                    $batch_cost=$b['product_cost'];
                }
             }
                            $data_free_product = array(
                                'cus_order_master_id' => $sale_id,
                                'product_id' => $row['product_id'],
                                'batch_id' => $last_read_batch_id,
                                'issue_qty' => $valid_free_issue_qty,
                                'order_qty' => $valid_free_issue_qty,
                                'product_cost' => $batch_cost,
                                'product_price' => 0,
                                'total_cost' => $batch_cost * $valid_free_issue_qty,
                                'is_free_issue' => 1,
                                'free_issue_id' => $return_result['fr_p_id'],
                            );
                            $this->order_items_in($data_free_product);
                        }
  }


}