<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Route_Model extends CI_Model {
  
  private $tableName = 'routes';
  
  function __construct() 
  {
    /* Call the Model constructor */
    parent::__construct();
  }
  
  function get_all_routes() {
		$this->db->select($this->tableName.'.*');
		$this->db->order_by("route_name", "desc");
		$this->db->where("route_id IS NOT NULL");//("id !=",$id);
		$query = $this->db->get($this->tableName);
		return $query->result();
  }

	function save_route($route_data,$route_id=false)
	{
		if (!$route_id)
		{
			$this->db->insert($this->tableName,$route_data);
		}else {
			$this->db->where('route_id', $route_id);
			return $this->db->update($this->tableName,$route_data);
		}
	}	

		function get_all_route_list() {
		$this->db->select($this->tableName.'.*');
		
		$this->db->order_by("route_id", "desc");
		$this->db->where("route_id IS NOT NULL");//("id !=",$id);
		$query = $this->db->get($this->tableName);
		return $query->result(); 
	}
	
		
	function get_all_route() {
		$this->db->select('routes.*,warehouses.name');
		$this->db->from('warehouses');
		$this->db->join('routes', 'routes.warehouse_id = warehouses.id', 'left');
		$this->db->order_by('route_id', 'desc');
		$this->db->where("route_id IS NOT NULL");//("id !=",$id);
		$query = $this->db->get();
		
		
		//print_r($query);
		return $query->result_array();
	}
	
	public function get_all_route_by_warehouse_id($warehouse_id)
	{
		$this->db->select('route_id,route_name');
		$this->db->from('routes');
		$this->db->where("warehouse_id", $warehouse_id);
		$this->db->where("route_status", 1);
		$query = $this->db->get();
		$data=array();
 
//$data[0] = 'SELECT'; 
foreach ($query->result() as $row)
{
$data[$row->route_id] = $row->route_name;
}
return ($data);
}


public function get_all_sale_rep_issue_by_route_id($route_id)
	{
		$this->db->select('sales_rep_issue_id,sales_rep_issue_ref_no');
		$this->db->from('sales_rep_issues');
		$this->db->where("route_id", $route_id);
		$this->db->where("status !='COMPLETED'");
		$query = $this->db->get();
		$data=array();
 
//$data[0] = 'SELECT'; 
foreach ($query->result() as $row)
{
$data[$row->sales_rep_issue_id] = $row->sales_rep_issue_ref_no;
}
return ($data);
}
		
	
	
	
	
	public function get_route_info($id)
	 {
		$this->db->select('*');
		$this->db->from($this->tableName);
		$this->db->where("route_id", $id);
		$this->db->order_by("route_id", "desc");
		$query = $this->db->get();
		return $query->row_array(); 
	 }
	
	public function delete_route($route_id)
	{
		$this->db->where('route_id', $route_id);
		$this->db->delete($this->tableName);
	
	}

	public function disable_route($route_id)
	{
		$data = array(
			'route_status' => 0
		);	
		$this->db->where('route_id', $route_id);
		$this->db->update($this->tableName, $data);
	}
	
	public function enable_route($route_id)
	{
		$data = array(
			'route_status' => 1
		);	
		$this->db->where('route_id', $route_id);
		$this->db->update($this->tableName, $data);
	}
}