<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Google_Map extends CI_Controller {

    var $main_menu_name = "google_map";
	var $sub_menu_name = "google_map";

	public function __construct()
	{
		parent::__construct();

		
		$this->load->model('Common_Model');
		$this->load->model('Google_Map_Model');
		$this->load->model('User_Model');
		$this->load->model('Marketing_Delivery_Model');
		
		date_default_timezone_set('asia/colombo');
		
	}
	
	public function index()
	{
		$data['main_menu_name'] = $this->main_menu_name;
		$data['sub_menu_name'] = $this->sub_menu_name;
		
		$delivery_id=$this->input->get('id');
		$date=$this->input->get('date');
		if($date){
		  $selected_date=date('Y-m-d', strtotime($date));  
		}else{
		$selected_date="";
		}
		$data['route_id'] = $delivery_id;
		$data['date'] = $selected_date;
		$delivary_details=$this->Marketing_Delivery_Model->get_delivary_details($delivery_id);	
		$customer_list = $this->Google_Map_Model->get_all_loan_customer_location_updated($delivary_details['area_id']);
		$rep_transaction_list = $this->Google_Map_Model->get_rep_transaction_location_map($delivery_id,$selected_date);
		$rep_visit_list = $this->Google_Map_Model->get_rep_visit_location_map($delivery_id,$selected_date);
		
	//	print_r($rep_visit_list);
		
		//--------------------map start
		$this->load->library('googlemaps');		
		$config['center'] = '37.4419, -122.1419';
		$config['zoom'] = 'auto';
		$this->googlemaps->initialize($config);
		foreach($customer_list as $cus){		
		$location_latitude=$cus['location_latitude'];
		$location_long=$cus['location_long'];		
		$marker = array();
		$marker['position'] = $location_latitude.','.$location_long;
		$marker['infowindow_content'] = '<strong>'.$cus['cus_name'].'</strong><br>'.$cus['cus_address'];
		$this->googlemaps->add_marker($marker);
		}		
		foreach($rep_transaction_list as $rept){
		    if($rept['transaction_type']=="PAYMENT"||$rept['transaction_type']=="INVOICE"){
		    }else{
		       continue; 
		    }
		$location_latitude=$rept['location_latitude'];
		$location_long=$rept['location_long'];		
		$marker = array();
		$marker['position'] = $location_latitude.','.$location_long;
		$marker['infowindow_content'] = 'Cus : '.$rept['cus_name'].'<br>'.'Rep : '.$rept['user_first_name'].'<br> time :'.$rept['time'];
		if($rept['transaction_type']=="PAYMENT"){
		$marker['icon'] = 'http://chart.apis.google.com/chart?chst=d_map_pin_letter&chld=P|FFFF00|000000';
		}else{
		    if($rept['transaction_type']=="INVOICE"){
		       $marker['icon'] = 'http://chart.apis.google.com/chart?chst=d_map_pin_letter&chld=IN|9999FF|000000'; 
		    }else{
		        $marker['icon'] = 'http://chart.apis.google.com/chart?chst=d_map_pin_letter&chld=T|0000FF|000000'; 
		    }
		    
		}
		$this->googlemaps->add_marker($marker);
		}		
		foreach($rep_visit_list as $repv){			
		$location_latitude=$repv['location_latitude'];
		$location_long=$repv['location_long'];		
		$marker = array();
		$marker['position'] = $location_latitude.','.$location_long;
		$marker['infowindow_content'] = 'Cus : '.$repv['cus_name'].'<br>'.'Rep : '.$repv['user_first_name'].'<br> time :'.$repv['time'];
		$marker['icon'] = 'http://chart.apis.google.com/chart?chst=d_map_pin_letter&chld=V|0000FF|000000';
		$this->googlemaps->add_marker($marker);
		}			
		$data['map'] = $this->googlemaps->create_map();	
		
		//-------------------------map end
		$this->load->view('map/dashboard', $data);		
	}
	
	
	
	public function list_routes()
	{
		$data['main_menu_name'] = $this->main_menu_name;
		$data['sub_menu_name'] = "list_routes";
		$this->load->view('map/route_list', $data);	
		
		
	}
	
	public function get_list_route()
	{
	 
	 $this->load->model('Route_Model');
	$requestData= $_REQUEST;
	
	$columns = array( 
		0 =>'route_code', 
		1 => 'route_name'
	);
	
	$data = array();
	$route = $this->Route_Model->get_all_route();
	$totalData = count($route);
	$totalFiltered = $totalData;  
	
	foreach ($route as $row){
		$nestedData=array(); 
		$nestedData[] =$row['route_code'];
		$nestedData[] = $row['route_name'];
		$nestedData[] = $row['name'];
		$actionTxtDisble='';
		$actionTxtEnable='';
		$actionTxtUpdate='';
		$actionTxtDelete='';
		
		if($row['route_status']==1){
			$actionTxtDisble = '<a class="btn btn-xs btn-green tooltips" data-placement="top" data-original-title="Disable supplier" ><i class="glyphicon fa fa-check"></i></a> &nbsp;';
	}
		if($row['route_status']==0){
			$actionTxtEnable = '<a class="btn btn-xs btn-warning tooltips" data-placement="top" data-original-title="Disable supplier" ><i class="glyphicon fa fa-minus-circle"></i></a> &nbsp;';
	}
		
	$date=date('d-m-Y');
	$nestedData[]=$actionTxtDisble.$actionTxtEnable;
	$nestedData[] = '<a href="' . base_url() . 'google_map?route_id=' . $row['route_id'] .'&date='.$date.'"><i class="fa fa-eye"> </i> Show Route</a>';
	$data[] = $nestedData;
}

	$json_data = array(
			//"draw"            => intval( $requestData['draw'] ),  
			"recordsTotal"    => intval( $totalData ),  
			"recordsFiltered" => intval( $totalFiltered ),
			"data"            => $data 
			);

	echo json_encode($json_data); 
	}
	
	
	public function list_rep_visited_details()
	{
	$route_id=$this->input->get('route_id');
	$date=$this->input->get('date');
	$selected_date=date('Y-m-d', strtotime($date));
	$requestData= $_REQUEST;
	
	$columns = array( 
		0 =>'unit_code', 
		1 => 'unit_name'
	);
	
	$data = array();
	$cus_list = $this->Google_Map_Model->get_all_loan_customer_location_updated_with_laons($route_id);
	$totalData = count($cus_list);
	$totalFiltered = $totalData;  
	
	foreach ($cus_list as $row){
		$nestedData=array(); 
		$cus_id =$row['cus_id'];
		
		$loan_list = $this->Google_Map_Model->get_customer_loan_list($cus_id,$selected_date);
		
		
		$thead="<thead><tr><td>Ref.No</td><td>Loan</td><td>Term</td><td>Paid</td></tr></thead>";
		
		$tbody="<tbody>";
		$tbody_end="</tbody>";
		$tr="<tr>";
		$tr_end="</tr>";
		$td="<td>";
		$td_end="</td>";
		$rows="";
		$table="";
		foreach($loan_list as $key)
		{
			$payment = $this->Google_Map_Model->get_loan_selected_date_payment($key['loan_id'],$selected_date);
			
			$selected_date_payment=0;
			
			if(isset($payment['pymnt_amount'])){
				
			$selected_date_payment=$payment['pymnt_amount'];	
			}
			
			$rows.=$tr.$td.'<a target="_blank" href="'.base_url().'loan/details/'.$key['loan_id'].'">'.$key['loan_ref'].'</a>'.$td_end.$td.$key['loan_tot_amount'].$td_end.$td.$key['loan_term_amount'].$td_end.$td.$selected_date_payment.$td_end.$tr_end;			
		}
		
		$table="<table  class='table table-bordered '>".$thead.$tbody.$rows.$tbody_end."</table>";
		
		
		$tran_count = $this->Google_Map_Model->get_transaction_count($cus_id,$selected_date);		
		$t_status = "";		
		if($tran_count>0){
			$t_status = '<a class="btn btn-xs btn-green tooltips" data-placement="top" data-original-title="Disable supplier" ><i class="glyphicon fa fa-check"></i></a> &nbsp;';
	}
	
	$visit_count = $this->Google_Map_Model->get_visit_count($cus_id,$selected_date);		
		$v_status = "";		
		if($visit_count>0){
			$v_status = '<a class="btn btn-xs btn-yellow tooltips" data-placement="top" data-original-title="Disable supplier" ><i class="glyphicon fa fa-check"></i></a> &nbsp;';
	}
		
		$nestedData[] = $row['cus_nic'];
		$nestedData[] = $row['cus_name'];
		$nestedData[] =$table;
		$nestedData[] = $row['cus_mobile'];
		$nestedData[] = $row['cus_address'];
		$nestedData[] = $t_status.$v_status;
		
		
	$nestedData[]="";
	$data[] = $nestedData;
}

	$json_data = array(
			//"draw"            => intval( $requestData['draw'] ),  
			"recordsTotal"    => intval( $totalData ),  
			"recordsFiltered" => intval( $totalFiltered ),
			"data"            => $data 
			//"data"            => "" 
			);

	echo json_encode($json_data); 
	}
	
	public function list_rep_visited_full_details()
	{
	$route_id=$this->input->get('route_id');
	$date=$this->input->get('date');
	if($date){
	$selected_date=date('Y-m-d', strtotime($date));
	}else{
	    $selected_date='';
	}
	$requestData= $_REQUEST;
	
	$columns = array( 
		0 =>'unit_code', 
		1 => 'unit_name'
	);
	
	$data = array();
	$cus_list = $this->Google_Map_Model->get_visit_transaction_details_all($route_id,$selected_date);
	$totalData = count($cus_list);
	$totalFiltered = $totalData;  
	
	foreach ($cus_list as $row){
		$nestedData=array(); 
		//$cus_id =$row['cus_id'];
		$tran="";
		if($row['transaction']==1)
		{
		$tran="Visit";	
		}
		else
		{
		$tran="Payment";		
		}
		
		$nestedData[] = $row['cus_name'];
		$nestedData[] = $row['date'];
		$nestedData[] = $row['time'];		
		$nestedData[] = $row['user_first_name'];
		$nestedData[] = $row['transaction_type'];
		$nestedData[] = $row['system_date_time'];
			
		
	$data[] = $nestedData;
}

	$json_data = array(
			//"draw"            => intval( $requestData['draw'] ),  
			"recordsTotal"    => intval( $totalData ),  
			"recordsFiltered" => intval( $totalFiltered ),
			"data"            => $data 
			);

	echo json_encode($json_data); 
	}


	
	
	
	
	
	
	
	
}